﻿using System.Linq;
using System.Threading.Tasks;

using Microsoft.Research.Oslo;

namespace Model_Lotki_Voltery
{
    class DataModel
    {
        private Options options = new Options { InitialStep = 1e-4 };

        public DataModel()
        {
        }

        public Task<SolPoint[]> Podstawowy(int t0, long V_t, long P_t, double r, double s, double a, double b)
        {
            return Task.Run(() =>
            {
                var solution = Ode.Euler(0, new Vector(V_t, P_t), (t, x) => new Vector(r * x[0] - a * x[0] * x[1], -s * x[1] + a * b * x[0] * x[1]), options);
                var points = solution.SolveFromToStep(0, t0, 1).ToArray();
                return points;
            });

        }

        public Task<SolPoint[]> Odlawianie(int t0, long V_t, long P_t, double r, double s, double a, double b, double y)
        {
            return Task.Run(() =>
            {
                var solution = Ode.RK547M(0, new Vector(V_t, P_t), (t, x) => new Vector((r - y) * x[0] - a * x[0] * x[1], -(s + y) * x[1] + a * b * x[0] * x[1]), options);
                var points = solution.SolveFromToStep(0, t0, 1).ToArray();
                return points;
            });
        }

        public Task<SolPoint[]> Srodowisko(int t0, long V_t, long P_t, double r, double s, double a, double b, double k)
        {
            return Task.Run(() =>
            {
                if (k == 0) k = 1;
                var solution = Ode.RK547M(0, new Vector(V_t, P_t), (t, x) => new Vector(r * x[0] * (1 - x[0] / k) - a * x[0] * x[1], -s * x[1] + a * b * x[0] * x[1]), options);
                var points = solution.SolveFromToStep(0, t0, 1).ToArray();
                return points;
            });
        }

        public Task<SolPoint[]> Kryjowki(int t0, long V_t, long P_t, double r, double s, double a, double b, double k)
        {
            return Task.Run(() =>
            {
                var solution = Ode.RK547M(0, new Vector(V_t, P_t), (t, x) => new Vector(r * x[0] - a * (x[0] - k) * x[1], -s * x[1] + a * b * (x[0] - k) * x[1]), options);
                var points = solution.SolveFromToStep(0, t0, 1).ToArray();
                return points;
            });
        }

        public Task<SolPoint[]> Konkurencja(int t0, long N1, long N2, double r1, double r2, double k1, double k2, double a12, double a21)
        {
            return Task.Run(() =>
            {
                var solution = Ode.RK547M(0, new Vector(N1, N2), (t, x) => new Vector(r1 * x[0] * (1 - x[0] / k1 - a12 * x[1] / k2), r2 * x[1] * (1 - x[1] / k2 - a21 * x[0] / k1)), options);
                var points = solution.SolveFromToStep(0, t0, 1).ToArray();
                return points;
            });
        }

        public Task<SolPoint[]> Symbioza(int t0, long N1, long N2, double r1, double r2, double k1, double k2, double b12, double b21)
        {
            return Task.Run(() =>
            {
                var solution = Ode.RK547M(0, new Vector(N1, N2), (t, x) => new Vector(r1 * x[0] * (1 - x[0] / k1 + b12 * x[1]), r2 * x[1] * (1 - x[1] / k2 + b21 * x[0])), options);
                var points = solution.SolveFromToStep(0, t0, 1).ToArray();
                return points;
            });
        }
    }
}
